<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * CrawlbaseScrap class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class CrawlbaseScrap extends Scrap
{
    const SLUG = 'crawlbase';

    public function doAction($url, $args)
    {
        // Find the first matching routing rule for this URL
        $rule = $this->getRoutingRuleForUrl($url);

        // If there is no matching rule, or it's for another provider, just return original URL.
        if (!$rule || !isset($rule['provider']) || $rule['provider'] !== $this->getSlug())
        {
            return $url;
        }

        // Mark this provider as used for this URL
        $this->markScrapingServiceUsed($url, $rule);

        $api_base = 'https://api.crawlbase.com/';

        // Base query args for Crawlbase
        $query_args = array(
            'token' => $this->getToken(),
            'url'   => $url,
        );

        // Extra params from rule, but do not allow overriding token or url
        $extra = $this->getExtraParamsFromRule($rule, array('token', 'url'));
        if (!empty($extra))
        {
            $query_args = array_merge($query_args, $extra);
        }

        $url = $api_base . '?' . http_build_query($query_args, '', '&');

        $url = apply_filters('affegg_parse_url_' . $this->getSlug(), $url);
        $url = apply_filters('affegg_parse_url_proxycrawl', $url); // legacy proxycrawl filter

        return $url;
    }
}
