<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * ScraperapiScrap class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class ScraperapiScrap extends Scrap
{
    const SLUG = 'scraperapi';

    public function doAction($url, $args)
    {
        $rule = $this->getRoutingRuleForUrl($url);

        if (!$rule || !isset($rule['provider']) || $rule['provider'] !== $this->getSlug())
        {
            return $url;
        }

        // Mark this provider as used for this URL
        $this->markScrapingServiceUsed($url, $rule);

        // Base query args for ScraperAPI
        $query_args = array(
            'api_key'      => $this->getToken(),
            'url'          => $url,
            'keep_headers' => 'false',
        );

        // Extra params from rule, but do not allow overriding api_key or url
        $extra = $this->getExtraParamsFromRule($rule, array('api_key', 'url'));

        if (!empty($extra))
        {
            $query_args = array_merge($query_args, $extra);
        }

        $api_endpoint = 'http://api.scraperapi.com';
        $query_args = array_map('rawurlencode', $query_args);

        $url = add_query_arg($query_args, $api_endpoint);

        $url = \apply_filters('affegg_parse_url_' . $this->getSlug(), $url);
        return $url;
    }
}
