<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * AsoscomParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class AsoscomParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'GBP';
    protected $_product = array();

    public function parseCatalog($max)
    {
        $path = array(
            ".//a[contains(@class, 'productLink_')]/@href",
        );

        return $this->xpathArray($path);
    }

    public function parsePrice()
    {
        if (preg_match('/"productPrice":{"current":{"value":(.+?),/', $this->dom->saveHtml(), $matches))
            return $matches[1];
        else
            return parent::parsePrice();
    }

    public function parseOldPrice()
    {
        if (preg_match('/,"previous":{"value":(.+?),/', $this->dom->saveHtml(), $matches))
            return $matches[1];
    }
}
