<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * BanggoodParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class BanggoodParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'USD';

    public function parseCatalog($max)
    {
        $path = array(
            ".//div[@class='p-wrap']//a/@href",
            ".//dd[@class='name']/a/@href",
            ".//span[@class='title']/a/@href",
            ".//*[@class='hot_others_box_c']//a[1]/@href",
            ".//a[@class='products_name']/@href",
            ".//ul/li//div[@class='p-wrap']//a[@class='title']/@href",
        );

        $urls = $this->xpathArray($path);

        if (!$urls && preg_match_all('/<a class="title" href="(.+?)" title=/', $this->html, $matches))
            $urls = $matches[1];

        foreach ($urls as $i => $url)
        {
            $urls[$i] = strtok($url, '?');
            if (!preg_match('~-p-\d+\.html~', $urls[$i]))
                unset($urls[$i]);
        }

        $urls = array_unique($urls);
        return $urls;
    }

    public function parseDescription()
    {
        $path = array(
            ".//div[@class='tab-cnt-description']",
        );

        if ($d = $this->xpathScalar($path, true))
        {
            $parts = explode('<div id="specification">', $d);
            if (count($parts) == 2)
                return '<div id="specification">' . $parts[1];
            else
                return $d;
        }
    }

    public function isInStock()
    {
        if ($p = parent::isInStock())
            return $p;

        if (strstr($this->xpathScalar(".//title"), 'Banggood.com sold out'))
            return false;
        if ($this->xpathScalar(".//*[@class='addToCartBtn_box']//a[contains(@class, 'arrivalnotice')]") == 'In Stock Alert')
            return false;

        return parent::isInStock();
    }
}
