<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * BestbuycomParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class BestbuycomParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'USD';
    protected $user_agent = 'ia_archiver';

    public function parseCatalog($max)
    {
        $path = array(
            ".//h4[@class='sku-title']/a/@href",
            ".//h3[@class='heading product-title']/a/@href",
            ".//h4[@class='sku-header']/a/@href",
        );

        return $this->xpathArray($path);
    }

    public function parseTitle()
    {
        if ($p = parent::parseTitle())
            return $p;

        return str_replace('- Best Buy', '', $this->xpathScalar(".//h1"));
    }

    public function parseDescription()
    {
        if (preg_match('/"plainText.+?":.+?"(.+?)"/', $this->dom->saveHtml(), $matches))
            return trim($matches[1], '" \\');

        $paths = array(
            ".//div[contains(@class, 'long-description-container')]",
            ".//div[@class='features-list all-features']",
            ".//div[contains(@id, 'shop-product-features')]",
        );

        if ($d = $this->xpathScalar($paths, true))
            return $d;
    }

    public function parsePrice()
    {
        if ($p = parent::parsePrice())
            return $p;

        $paths = array(
            ".//*[@class='priceView-hero-price priceView-customer-price']/span[1]",
            ".//*[@class='pb-hero-price pb-purchase-price']",
            ".//*[contains(@class, 'priceView-hero-price')]/span",
        );

        return $this->xpathScalar($paths);
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//div[@class='pricing-price__regular-price']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseManufacturer()
    {
        return $this->xpathScalar(".//meta[@id='schemaorg-brand-name']/@content");
    }

    public function parseImg()
    {
        return $this->xpathScalar(".//meta[@property='og:image']/@content");
    }
}
