<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * CoolbluenlParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class CoolbluenlParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'EUR';
    protected $user_agent = array('Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:100.0) Gecko/20100101 Firefox/100.0');

    public function parseCatalog($max)
    {
        $urls = array_slice($this->xpathArray(".//*[@id='direct-naar-resultaten' or @id='facet_productlist']//h2/a/@href"), 0, $max);

        if (!$urls)
            $urls = array_slice($this->xpathArray(".//div[contains(@class, 'product-card__title')]//a[@class='link']/@href"), 0, $max);

        if (!$urls)
            $urls = array_slice($this->xpathArray(".//*[@class='product__display']//a/@href"), 0, $max);

        if (!$urls)
            $urls = array_slice($this->xpathArray(".//a[contains(@class, 'product__title')]//a[@class='link']/@href"), 0, $max);

        // top lists
        if (!$urls)
            $urls = array_slice($this->xpathArray(".//*[@class='productlist_item_top_product']//h4/a/@href"), 0, $max);

        $urls = array_unique($urls);

        $host = parse_url($this->getUrl(), PHP_URL_HOST);
        foreach ($urls as $i => $url)
        {
            if (!preg_match('/^https?:\/\//', $url))
                $urls[$i] = 'https://' . $host . $url;
        }
        return $urls;
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//span[@class='sales-price__former-price']",
            ".//div[@class='grid-section-xs--gap-4']//*[@class='sales-price__former-price']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseExtra()
    {
        $extra = parent::parseExtra();

        $html = $this->dom->saveHtml();
        if (preg_match('/"ratingValue": "(.+?)"/', $html, $matches))
        {
            $rating = (float) str_replace(',', '.', $matches[1]);
            $extra['rating'] = TextHelper::ratingPrepare(TextHelper::convertRatingScale($rating, 1, 10, 1, 5));
            $extra['ratingDecimal'] = round(TextHelper::convertRatingScale($rating, 1, 10, 1, 5), 2);
            $extra['ratingScale10'] = round($rating, 2);
        }
        if (preg_match('/"reviewCount":\s?"?(\d+)"?/', $html, $matches))
        {
            $extra['ratingCount'] = (int) $matches[1];
        }

        return $extra;
    }

    public function getFeaturesXpath()
    {
        return array(
            array(
                'name' => ".//div[contains(@class, 'js-specifications-content')]//dt[contains(@class, 'product-specs__item-title')]",
                'value' => ".//div[contains(@class, 'js-specifications-content')]//dd[contains(@class, 'product-specs__item-spec')]",
            ),
        );
    }

    public function isInStock()
    {
        if (isset($this->ld_json['offers'][0]['availability']))
            $availability = $this->ld_json['offers'][0]['availability'];
        elseif (isset($this->ld_json['offers']['availability']))
            $availability = $this->ld_json['offers']['availability'];
        else
            $availability = '';

        if ($availability && in_array($availability, array('OutOfStock', 'SoldOut', 'http://schema.org/OutOfStock', 'https://schema.org/OutOfStock', 'http://schema.org/SoldOut', 'https://schema.org/SoldOut')))
            return false;
        else
            return true;
    }

    public function parseFeatures()
    {
        if (!$xpaths = $this->getFeaturesXpath())
            return array();

        if (isset($xpaths['name']) || isset($xpaths['name-value']))
            $xpaths = array($xpaths);

        foreach ($xpaths as $xpath)
        {
            $names = $values = array();

            if (isset($xpath['name-value']))
            {
                if (!$name_values = $this->xpathArray($xpath['name-value']))
                    continue;

                if (isset($xpath['separator']))
                    $separator = $xpath['separator'];
                else
                    $separator = ':';

                foreach ($name_values as $name_value)
                {
                    $parts = explode($separator, $name_value, 2);
                    if (count($parts) !== 2)
                        continue;

                    $names[] = $parts[0];
                    $values[] = $parts[1];
                }
            }
            elseif (isset($xpath['name']) && isset($xpath['value']))
            {
                $names = $this->xpathArray($xpath['name']);
                $values = $this->xpathArray($xpath['value']);
            }

            if (!$names || !$values || count($names) != count($values))
                continue;

            $features = array();
            for ($i = 0; $i < count($names); $i++)
            {
                $feature = array();
                $names[$i] = preg_replace("/[^\pL\s\d\-\.\+_]+/ui", '', $names[$i]);
                $feature['name'] = ucfirst(\sanitize_text_field(trim($names[$i], " \r\n:-")));
                $feature['value'] = trim(\sanitize_text_field($values[$i]), " \r\n:-");
                $feature['value'] = preg_replace('/(\x{200e}|\x{200f})/u', '', $feature['value']);
                if (in_array($feature['name'], array('Condition', 'Customer Reviews', 'Best Sellers Rank')))
                    continue;
                $features[] = $feature;
            }

            if ($features)
                return $features;
        }
        return array();
    }
}
