<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * MercadolivrecombrParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class MercadolivrecombrParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'BRL';
    protected $_ld;

    public function parseCatalog($max)
    {
        $path = array(
            ".//a[@class='poly-component__title']/@href",
            ".//a[contains(@class, 'poly-component__title')]/@href",
            ".//h2[@class='poly-box poly-component__title']//a[contains(@href, '/p/')]/@href",
            ".//a[contains(@class, 'ui-search-item__group__element')]/@href",
            ".//h2[contains(@class, 'item__title')]/a/@href",
            "id('searchResults')//a/@href",
        );

        $urls = $this->xpathArray($path);

        foreach ($urls as $i => $url)
        {
            if (strstr($url, 'clicks/external'))
                unset($urls[$i]);

            $urls[$i] = strtok($url, '?');
            $urls[$i] = strtok($urls[$i], '#');
        }

        $urls = array_unique($urls);

        return $urls;
    }

    public function parseTitle()
    {
        // out of stock product
        $paths = array(
            ".//h2[contains(@class, 'andes-technical-error__title')]",
        );

        if ($this->xpathScalar($paths))
        {
            return 'Out of Stock';
        }

        if ($p = parent::parseTitle())
        {
            return $p;
        }

        $paths = array(
            ".//a[@class='poly-component__title']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseImg()
    {
        if ($p = parent::parseImg())
            return $p;

        $paths = array(
            ".//img[contains(@class, 'poly-component__picture')]/@data-src",
        );

        return $this->xpathScalar($paths);
    }

    public function parsePrice()
    {
        if (!$this->isInstock())
        {
            return null;
        }

        if ($p = parent::parsePrice())
            return $p;

        $paths = array(
            ".//div[@class='poly-component__price']//div[@class='poly-price__current']//span[@class='andes-money-amount__fraction']",
        );

        $p1 = $this->xpathScalar($paths);

        $paths = array(
            ".//div[@class='poly-component__price']//div[@class='poly-price__current']//span[@class='andes-money-amount__cents andes-money-amount__cents--superscript-24']",
        );

        $p2 = $this->xpathScalar($paths);

        return $p1 . '.' . $p2;
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//s[contains(@class, 'ui-pdp-price__original-value')]//span[@class='andes-money-amount__fraction']",
            ".//div[@class='poly-component__price']//s",

        );

        return $this->xpathScalar($paths);
    }

    public function parseDescription()
    {
        $paths = array(
            ".//ul[@class='ui-pdp-features mt-24']",
            ".//p[@class='ui-pdp-description__content']",
        );

        return $this->xpathScalar($paths, true);
    }

    public  function isInstock()
    {
        $paths = array(
            ".//h2[contains(@class, 'andes-technical-error__title')]",
        );

        if ($this->xpathScalar($paths))
        {
            return false;
        }
        else
        {
            return parent::isInstock();
        }
    }
}
