<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * RozetkacomuaParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class RozetkacomuaParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'UAH';

    public function parseCatalog($max)
    {
        $path = array(
            ".//a[@class='tile-title black-link text-base']/@href",
            ".//a[@class='goods-tile__heading']/@href",
        );

        if ($urls = $this->xpathArray($path))
            return $urls;

        // category
        if (preg_match_all('/price_pcs&q;:&q;.+?&q;,&q;href&q;:&q;(.+?)&q;,&q;comments_amount/', $this->dom->saveHTML(), $matches))
            return $matches[1];

        // search
        if ($urls = $this->_parseSearchPage())
            return $urls;

        if ($this->parseTitle())
        {
            // redirect from search to product page
            return array($this->xpathScalar(".//meta[@property='og:url']/@content"));
        }

        return array();
    }

    private function _parseSearchPage()
    {
        if (!preg_match('~text=(.+)&~', $this->getUrl(), $matches))
            return array();

        $keyword = $matches[1];
        try
        {
            $result = $this->requestGet('https://search.rozetka.com.ua/search/api/v4/?text=' . $keyword . '', false);
        }
        catch (\Exception $e)
        {
            return array();
        }
        $result = json_decode($result, true);
        if (!$result || !isset($result['data']['goods']))
            return array();
        $urls = array();
        foreach ($result['data']['goods'] as $item)
        {
            $urls[] = $item['href'];
        }
        return $urls;
    }

    public function parseDescription()
    {
        $xpath = array(
            ".//div[contains(@class, 'product-about__sticky')]//p[@class='mt-4']",
            ".//rz-store-rich-content",
            ".//div[contains(@class, 'product-about__description-content')]",
        );

        $desc =  $this->xpathScalar($xpath, true);

        $desc = preg_replace('/<style.*?<\/style>/is', '', $desc);
        $desc = preg_replace('/<script.*?<\/script>/is', '', $desc);

        if ($desc)
            return $desc;
        else
            return parent::parseDescription();
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//div[@class='product-price__wrap']//p[@class='product-price__small']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseImage()
    {
        if ($images = $this->parseImages())
            return reset($images);
    }

    public function parseImages(): array
    {
        $paths = [
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@src",
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@data-src",
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@srcset",
        ];

        $raw = $this->xpathArray($paths) ?: [];
        $images = [];

        foreach ($raw as $item)
        {
            $item = trim((string)$item);
            if ($item === '')
            {
                continue;
            }

            // If this is a srcset, pick the largest candidate (usually the last one)
            if (strpos($item, ',') !== false && preg_match_all('/\s*([^,\s]+)\s+\d+w/', $item, $m) && !empty($m[1]))
            {
                $item = trim(end($m[1]));
            }

            // Upgrade path segment to /big/ when applicable
            $url = preg_replace('#/(medium|preview|base_action)/#', '/big/', $item);

            $images[] = $url;
        }

        $images = array_values(array_unique($images));

        return $images;
    }
    public function parseFeatures()
    {
        if ($features = parent::parseFeatures())
            return $features;

        $names = $this->xpathArray(".//div[@class='product-wrapper__right']//dt");
        $values = $this->xpathArray(".//div[@class='product-wrapper__right']//dd", true);

        if (!$names || !$values || count($names) != count($values))
            return array();

        $features = array();
        for ($i = 0; $i < count($names); $i++)
        {
            $value = str_replace('</li>', '</li>; ', $values[$i]);
            $feature['name'] = \sanitize_text_field($names[$i]);
            $feature['value'] = \sanitize_text_field(html_entity_decode($value));
            $features[] = $feature;
        }

        return $features;
    }
}
