<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * RuiherbcomParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class RuiherbcomParser extends LdShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'USD';

    public function parseCatalog($max)
    {
        $xpath = array(
            ".//div[@itemtype='http://schema.org/Product']//a[contains(@href, '/pr/')]/@href",
            ".//div[contains(@class, 'products')]//div[@class='absolute-link-wrapper']/a/@href",
            ".//*[contains(@class, 'product-inner')]/a[1]/@href",
            ".//div[@class='panel']//a[@class='image-link']/@href",
            ".//div[@id='display-results-content']//a[@class='image-link']/@href",
            ".//div[@class='panel']/article/a[@class='image-link']/@href",
            ".//div[@class='panel']//bdi//a[@class='product-image']/@href",
            ".//*[@class='absolute-link-wrapper']/a/@href",
            ".//*[contains(@class, 'product-link')]/a/@href",
        );

        return $this->xpathArray($xpath);
    }

    public function parseOldPrice()
    {
        return $this->xpathScalar(".//div[@class='price']//span[@class='list-price']");
    }
}
