<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * TikivnParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class TikivnParser extends MicrodataShopParser
{

    protected $charset = 'utf-8';
    protected $currency = 'VND';
    private $_oldPrice;

    public function parseCatalog($max)
    {
        if (preg_match_all('/"url_path":"([^"]+)","availability"/', $this->dom->saveHtml(), $matches))
            $urls = $matches[1];
        else
            $urls = array();

        if (!$urls)
        {
            $path = array(
                ".//a[@class='product-item']/@href",
                ".//div[contains(@class, 'product-item')]//a/@href",
                ".//*[@class='search-a-product-item']",
                ".//p[@class='title']/a/@href",
            );

            $urls = $this->xpathArray($path);
        }

        foreach ($urls as $i => $url)
        {
            $urls[$i] = strtok($url, '?');
        }

        return $urls;
    }

    public function parseTitle()
    {
        if ($p = parent::parseTitle())
            return $p;
        else
            return $this->xpathScalar(".//h1");
    }

    public function parsePrice()
    {
        $prices = $this->_getTikiVariationPrices();
        if ($prices)
        {
            $price = $prices['sale_price'];
            $this->_oldPrice = $prices['old_price'];
            return $price;
        }

        $html = $this->dom->saveHTML();

        if (preg_match('/"price":(\d+),"/', $html, $matches))
            return $matches[1];

        if ($p = parent::parsePrice())
            return $p;

        $path = array(
            ".//div[@class='product-price__current-price']",
        );
        return $this->xpathScalar($path);
    }

    public function parseDescription()
    {
        $path = array(
            ".//div[@class='content']//div[contains(@class, 'ToggleContent__Wrapper-sc')]",
            ".//div[@class='summary']//div[@class='group border-top']",
        );

        return $this->xpathScalar($path, true);
    }

    public function parseImg()
    {
        return str_replace('/280x280/', '/368x368/', parent::parseImg());
    }

    public function parseOldPrice()
    {
        if ($this->_oldPrice)
        {
            return $this->_oldPrice;
        }

        $html = $this->dom->saveHTML();

        if (preg_match('/"original_price":(\d+),"/', $html, $matches))
            return $matches[1];

        if (preg_match('/,"list_price":(\d+),"/', $html, $matches))
            return $matches[1];

        $paths = array(
            ".//div[@class='summary']//p[@class='original-price']",
        );

        if ($price = $this->xpathScalar($paths))
            return $price;
    }

    public function getFeaturesXpath()
    {
        return array(
            array(
                'name' => ".//div[contains(@class, 'ProductDescription__Wrapper')]//table//tr/td[1]",
                'value' => ".//div[contains(@class, 'ProductDescription__Wrapper')]//table//tr/td[2]",
            ),
            array(
                'name' => ".//div[contains(@class, 'style__Wrapper')]//table//tr/td[1]",
                'value' => ".//div[contains(@class, 'style__Wrapper')]//table//tr/td[2]",
            ),
        );
    }

    protected function _getTikiVariationPrices()
    {
        $productUrl = $this->getUrl();

        $jsonData = $this->xpathScalar(".//script[@id='__NEXT_DATA__']");

        if (!$jsonData)
        {
            return false;
        }

        // 1) Parse the URL to get the spid
        $query = parse_url($productUrl, PHP_URL_QUERY);
        parse_str($query, $params);
        $spid = $params['spid'] ?? null;

        // 2) Decode the JSON
        $data = json_decode($jsonData, true);
        if (json_last_error() !== JSON_ERROR_NONE)
        {
            return false;
        }

        // 3) Navigate into initialState → productv2 → productData → response → data
        if (empty($data['props']['initialState']['productv2']['productData']['response']['data']))
        {
            return false;
        }

        $prod = $data['props']['initialState']['productv2']['productData']['response']['data'];

        // 4) If there are variations, find the one matching the URL’s spid
        if (!empty($prod['configurable_products']) && $spid !== null)
        {
            foreach ($prod['configurable_products'] as $variation)
            {
                if ((string)($variation['id'] ?? '') === $spid)
                {
                    return [
                        'sale_price' => (int)($variation['price'] ?? $prod['price']),
                        'old_price'  => (int)($variation['original_price'] ?? $prod['original_price']),
                    ];
                }
            }
        }

        // 5) Fallback to the master product’s prices
        return [
            'sale_price' => (int)($prod['price']          ?? 0),
            'old_price'  => (int)($prod['original_price'] ?? $prod['list_price'] ?? 0),
        ];
    }
}
