<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * UdemycomParser class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class UdemycomParser extends MicrodataShopParser
{

    protected $_product_id;
    protected $_prices;
    protected $_total_page = 1;

    protected $charset = 'utf-8';
    protected $currency = 'USD';

    public function parseCatalog($max)
    {
        // search page with JS rendering enabled
        $xpath = ".//h3[@data-purpose='course-title-url']";
        if ($urls = $this->xpathArray($xpath))
        {
            return $urls;
        }

        // search page
        if (!$query = parse_url($this->getUrl(), PHP_URL_QUERY))
            return array();
        parse_str($query, $arr);
        if (!isset($arr['q']))
            return array();

        $request_url = 'https://www.udemy.com/api-2.0/search-courses/?src=ukw&q=' . urlencode($arr['q']) . '&skip_price=true';

        $headers = [
            'User-Agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:136.0) Gecko/20100101 Firefox/136.0',
            'Accept' => 'application/json, text/plain, */*',
            'Accept-Language' => 'en-US',
            'Referer' => $this->getUrl(),
            'X-Requested-With' => 'XMLHttpRequest',
            'X-Udemy-Cache-Brand' => 'UAen_US',
            'X-Udemy-Cache-Marketplace-Country' => 'US',
            'X-Udemy-Cache-Price-Country' => 'US',
            'X-Udemy-Cache-Version' => '1',
            'X-Udemy-Cache-Language' => 'en',
            'X-Udemy-Cache-Device' => 'None',
            'X-Udemy-Cache-Logged-In' => '1',
            'Connection' => 'keep-alive',
            'Sec-Fetch-Dest' => 'empty',
            'Sec-Fetch-Mode' => 'cors',
            'Sec-Fetch-Site' => 'same-origin',
            'Pragma' => 'no-cache',
            'Cache-Control' => 'no-cache',
            'TE' => 'trailers',
        ];

        if (!$response = $this->getRemoteJson($request_url, $headers))
            return;

        if (!isset($response['courses']))
            return array();

        $urls = array();
        foreach ($response['courses'] as $r)
        {
            $urls[] = str_replace('learn/', '', $r['learn_url']);
        }

        return $urls;
    }

    public function parseTitle()
    {
        $title = parent::parseTitle();
        $this->_getPrices();

        if ($t = $this->xpathScalar(".//h1[@data-purpose='lead-title']"))
            return $t;
        else
            return $title;
    }

    protected function _getPrices()
    {
        $product_id = $this->xpathScalar(".//body/@data-clp-course-id");
        if (!$product_id)
        {
            $img = $this->xpathScalar(".//meta[@property='og:image']/@content");
            if (preg_match('/480x270\/(\d+)_/', $img, $matches))
                $product_id = $matches[1];
        }

        $this->_product_id = $product_id;
        if (!$this->_product_id)
            return;

        $url = 'https://www.udemy.com/api-2.0/course-landing-components/' . urlencode($product_id) . '/me/?components=price_text,deal_badge,discount_expiration,redeem_coupon,gift_this_course,base_purchase_section,purchase_tabs_context,subscribe_team_modal_context,lifetime_access_context';

        $headers = array(
            'User-Agent' => 'ia_archiver',
            'X-Requested-With' => 'XMLHttpRequest',
        );

        $response = $this->getRemoteJson($url, $headers);

        if ($response && isset($response['price_text']['data']))
        {
            $this->_prices = $response['price_text']['data'];
        }
    }

    public function parseDescription()
    {
        $xpath = [
            ".//div[@data-purpose='safely-set-inner-html:description:description']",
        ];
        return $this->xpathScalar($xpath, true);
    }

    public function parseShortDescription()
    {
        $paths = array(
            ".//div[@class='udlite-text-md clp-lead__headline']",
        );

        return $this->xpathScalar($paths, true);
    }

    public function parsePrice()
    {
        if (isset($this->_prices['pricing_result']['price']['amount']))
            return $this->_prices['pricing_result']['price']['amount'];
        elseif (isset($this->_prices['pricing_result']['list_price']['amount']))
            return $this->_prices['pricing_result']['list_price']['amount'];
        elseif (isset($this->_prices['list_price']['amount']))
            return $this->_prices['list_price']['amount'];

        $paths = array(
            ".//meta[@property='udemy_com:price']/@content",
        );

        return $this->xpathScalar($paths);
    }

    public function parseOldPrice()
    {
        if (isset($this->_prices['list_price']['amount']))
            return $this->_prices['list_price']['amount'];
    }

    public function parseManufacturer()
    {
        $paths = array(
            ".//div[@data-purpose='instructor-name-top']//a[1]/span",
        );

        return $this->xpathScalar($paths);
    }

    public function parseReviews()
    {
        if (!$this->_product_id)
            return array();

        $headers = array(
            'User-Agent' => 'ia_archiver',
            'X-Requested-With' => 'XMLHttpRequest',
        );

        $url = 'https://www.udemy.com/api-2.0/courses/' . urlencode($this->_product_id) . '/reviews/?courseId=' . urlencode($this->_product_id) . '&page=1&is_text_review=1&ordering=course_review_score__rank,-created&fields[course_review]=@default,response,content_html,created_formatted_with_time_since&fields[user]=@min,image_50x50,initials&fields[course_review_response]=@min,user,content_html,created_formatted_with_time_since';
        $response = $this->getRemoteJson($url, $headers);

        if (!$response || !isset($response['results']))
            return array();

        $results = array();
        foreach ($response['results'] as $r)
        {
            $review = array();
            if (!isset($r['content_html']))
                continue;

            $review['comment'] = $r['content_html'];

            if (isset($r['rating']))
                $review['rating'] = TextHelper::ratingPrepare($r['rating']);

            if (isset($r['user']['display_name']))
                $review['author'] = $r['user']['display_name'];

            if (isset($r['created']))
                $review['date'] = strtotime($r['created']);

            $results[] = $review;
        }
        return $results;
    }

    public function getCurrency()
    {
        if (isset($this->_prices['pricing_result']['price']['currency']))
            return $this->_prices['pricing_result']['price']['currency'];
    }
}
