<?php
defined('\ABSPATH') || exit;
/*
  Name: List
 */
__('List', 'affegg-tpl');

use Keywordrush\AffiliateEgg\TemplateHelper;
?>

<?php $this->enqueueStyle(); ?>

<div class="egg-container egg-list">

    <div class="egg-listcontainer">
        <?php foreach ($items as $item): ?>
            <div class="cegg-list-logo-title cegg-mt5 cegg-mb5 visible-xs text-center">
                <a rel="nofollow" target="_blank" href="<?php echo $item['url']; ?>"<?php echo $item['ga_event'] ?>>
                    <?php echo esc_html(TemplateHelper::truncate($item['title'], 120)); ?><?php if ($item['manufacturer']): ?>, <?php echo esc_html($item['manufacturer']); ?><?php endif; ?>                            
                </a>
            </div>

            <div class="row-products">
                <div class="col-md-2 col-sm-2 col-xs-12 cegg-image-cell">
                    <?php if ($item['img']): ?>
                        <a rel="nofollow" target="_blank" href="<?php echo $item['url']; ?>"<?php echo $item['ga_event'] ?>>
                            <img src="<?php echo $item['img']; ?>" alt="<?php echo esc_attr($item['title']); ?>" />
                        </a>
                    <?php endif; ?>
                </div>
                <div class="col-md-7 col-sm-7 col-xs-12 cegg-desc-cell hidden-xs">
                    <h4 class="cegg-no-top-margin">
                        <a rel="nofollow" target="_blank" href="<?php echo $item['url']; ?>"<?php echo $item['ga_event'] ?>>
                            <?php echo esc_html(TemplateHelper::truncate($item['title'], 120)); ?><?php if ($item['manufacturer']): ?>, <?php echo esc_html($item['manufacturer']); ?><?php endif; ?>                            
                        </a>
                    </h4>
                    <?php if (!empty($item['domain'])): ?>
                        <div class="cegg-mb5">
                            <img src="<?php echo esc_attr(TemplateHelper::getMerhantIconUrl($item, true)); ?>" /> <small class="text-muted"><?php echo $item['domain']; ?></small>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="col-md-3 col-sm-3 col-xs-12 cegg-price-cell text-center">
                    <div class="cegg-price-row">
                        <?php if ($item['old_price']): ?>
                            <span class="text-muted"><strike><?php echo TemplateHelper::formatPriceCurrency($item['old_price_raw'], $item['currency_code'], '<small>', '</small>'); ?></strike></span><br>
                        <?php endif; ?>
                        <?php if ($item['price']): ?>
                            <span class="cegg-price cegg-price-color"><?php echo TemplateHelper::formatPriceCurrency($item['price_raw'], $item['currency_code'], '<span class="cegg-currency">', '</span>'); ?></span>
                        <?php endif; ?> 
                    </div>         
                    <div class="cegg-btn-row cegg-mb10">
                        <a rel="nofollow" target="_blank" href="<?php echo $item['url']; ?>" class="btn btn-danger btn-block"<?php echo $item['ga_event'] ?>><?php TemplateHelper::buyNowBtnText(true, $item); ?></a> 
                    </div>  
                </div>
            </div>        
        <?php endforeach; ?>

    </div>   
    <?php if ($see_more_uri): ?>
        <div class="row">
            <div class="col-md-12 text-center"> 
                <hr>
                <a class="btn btn-info" rel="nofollow" target="_blank" href="<?php echo $see_more_uri; ?>"><?php _e('See more...', 'affegg-tpl'); ?></a>
            </div>
        </div>
    <?php endif; ?>


</div>