<?php defined( '\ABSPATH' ) || exit;
/*
  Name: Price comparison (full)
 */
__('Price comparison (full)', 'affegg-tpl');

use Keywordrush\AffiliateEgg\TemplateHelper;
?>
<?php $this->enqueueStyle(); ?>

<div class="egg-container">
    <div class="container-fluid">
        <div class="col-md-5">
            <?php if ($items[0]['img']): ?>
                <img class="img-responsive" src="<?php echo esc_attr($items[0]['img']) ?>" alt="<?php echo esc_attr($items[0]['title']); ?>" />
            <?php endif; ?>
        </div>
        <div class="col-md-7">
            <h2 class="cegg-no-top-margin"><?php echo esc_html($items[0]['title']); ?><?php if ($items[0]['manufacturer']): ?>, <?php echo esc_html($items[0]['manufacturer']); ?><?php endif; ?></h2>
            <?php
            // sort items by price
            usort($items, function($a, $b) {
                if (!$a['price_raw'])
                    return 1;
                if (!$b['price_raw'])
                    return -1;
                return $a['price_raw'] - $b['price_raw'];
            });
            ?>
            <div class="list-group cegg-mt10">

                <?php foreach ($items as $key => $item): ?>
                    <a rel="nofollow" class="list-group-item" target="_blank" href="<?php echo esc_url($item['url']) ?>"<?php echo $item['ga_event'] ?>>
                        <img src="<?php echo esc_attr(TemplateHelper::getMerhantIconUrl($item, false)); ?>" />
                        <?php echo \esc_html($item['domain']); ?>
                        <?php if ($item['price']): ?>
                            <span style="background-color: #dc3545;" class="cegg-price cegg-price-badge"><?php echo TemplateHelper::formatPriceCurrency($item['price_raw'], $item['currency_code']); ?></span>
                        <?php endif; ?>
                    </a>
                <?php endforeach; ?>            
            </div>           
        </div>
    </div>    

    <div class="row">
        <div class="col-md-12">
            <div class="cegg-mb25">
                <?php $item = $items[0]; ?>
                <?php if ($item['description']): ?>
                    <h4 class="cegg-no-top-margin"><?php _e('Description', 'affegg-tpl'); ?></h4>
                    <p><?php echo $item['description']; ?></p>
                <?php endif; ?>                    

                <?php if (!empty($item['extra']['features'])): ?>
                    <div class="cegg-features-box">
                        <h4 class="cegg-no-top-margin"><?php _e('Features', 'affegg-tpl'); ?></h4>
                        <ul class="cegg-feature-list">
                            <?php foreach ($item['extra']['features'] as $feature): ?>
                                <li><strong><?php echo esc_html($feature['name']) ?></strong>: <?php echo esc_html($feature['value']) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>                        
                <?php endif; ?>                     

                <?php if (!empty($item['extra']['comments'])): ?>
                    <h4 class="cegg-no-top-margin"><?php _e('User reviews', 'affegg-tpl'); ?></h4>

                    <?php foreach ($items as $item): ?>
                        <?php foreach ($item['extra']['comments'] as $key => $comment): ?>
                            <div class="cegg-review-block">
                                <blockquote>
                                    <?php if (!empty($comment['rating'])): ?>
                                        <span class="rating_small">
                                            <?php echo str_repeat("<span>★</span>", (int) $comment['rating']); ?><?php echo str_repeat("<span>☆</span>", 5 - (int) $comment['rating']); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php echo esc_html($comment['comment']); ?>
                                </blockquote>
                            </div>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                <?php endif; ?>	



            </div>
        </div>
    </div>

    <?php if ($see_more_uri): ?>
        <div class="row">
            <div class="col-md-12 text-center"> 
                <a class="btn btn-info" rel="nofollow" target="_blank" href="<?php echo $see_more_uri; ?>"><?php _e('See more...', 'affegg'); ?></a>
            </div>
        </div>
    <?php endif; ?>
</div>