<?php
defined('\ABSPATH') || exit;
/*
  Name: Price comparison (short)
 */
__('Price comparison (short)', 'affegg-tpl');

use Keywordrush\AffiliateEgg\TemplateHelper;
?>

<?php $this->enqueueStyle(); ?>

<div class="egg-container">
    <div class="container-fluid">
        <div class="col-md-5">
            <?php if ($items[0]['img']): ?>
                <img class="img-responsive" src="<?php echo esc_attr($items[0]['img']) ?>" alt="<?php echo esc_attr($items[0]['title']); ?>" />
            <?php endif; ?>
        </div>
        <div class="col-md-7">
            <h3 class="cegg-no-top-margin"><?php echo esc_html($items[0]['title']); ?><?php if ($items[0]['manufacturer']): ?>, <?php echo esc_html($items[0]['manufacturer']); ?><?php endif; ?></h3>
            <?php
            // sort items by price
            usort($items, function($a, $b) {
                if (!$a['price_raw'])
                    return 1;
                if (!$b['price_raw'])
                    return -1;
                return $a['price_raw'] - $b['price_raw'];
            });
            ?>


            <div class="list-group cegg-mt10">

                <?php foreach ($items as $key => $item): ?>
                    <a rel="nofollow" class="list-group-item" target="_blank" href="<?php echo esc_url($item['url']) ?>"<?php echo $item['ga_event'] ?>>
                        <img src="<?php echo esc_attr(TemplateHelper::getMerhantIconUrl($item, false)); ?>" />
                        <?php echo \esc_html($item['domain']); ?>
                        <?php if ($item['price']): ?>
                            <span style="background-color: #dc3545;" class="cegg-price cegg-price-badge"><?php echo TemplateHelper::formatPriceCurrency($item['price_raw'], $item['currency_code']); ?></span>
                        <?php endif; ?>
                    </a>
                <?php endforeach; ?>            
            </div>             

        </div>
    </div>
</div>