<?php
defined('\ABSPATH') || exit;
/*
  Name: Tile (3 columns)
 */
__('Tile (3 columns)', 'affegg-tpl');
?>

<?php $this->enqueueStyle(); ?>

<div class="egg-container egg-grid">

    <?php $i = 0; ?>
    <div class="row">
        <?php foreach ($items as $item): ?>

            <div class="col-md-4 col-xs-6 cegg-gridbox"> 
                <a rel="nofollow" target="_blank" href="<?php echo esc_url($item['url']) ?>">
                    <div class="cegg-thumb">
                        <?php if ($item['img']): ?>
                            <img src="<?php echo esc_attr($item['img']) ?>" alt="<?php echo esc_attr($item['title']); ?>" />
                        <?php endif; ?>
                    </div>
                </a>
            </div>
            <?php
            $i++;
            if ($i % 3 == 0)
                echo '<div class="clearfix hidden-xs"></div>';
            if ($i % 2 == 0)
                echo '<div class="clearfix visible-xs-block"></div>';
            ?>       
        <?php endforeach; ?>  

    </div>

    <?php if ($see_more_uri): ?>
        <div class="row">
            <div class="col-md-12 text-center"> 
                <hr>
                <a class="btn btn-info" rel="nofollow" target="_blank" href="<?php echo $see_more_uri; ?>"><?php _e('See more...', 'affegg-tpl'); ?></a>
            </div>
        </div>
    <?php endif; ?>

</div>
