<?php defined( '\ABSPATH' ) || exit;
/*
  Name: List
 */
__('List', 'affegg-tpl');

use Keywordrush\AffiliateEgg\TemplateHelper;
?>

<?php $this->enqueueStyle(); ?>

<div class="egg-container egg-list">

    <div class="egg-listcontainer">

        <?php foreach ($items as $i => $item): ?>
            <div class="row-products">

                <div class="col-md-5 col-sm-5 col-xs-12 cegg-image-cell">
                    <a rel="nofollow" target="_blank" href="<?php echo esc_url($item['url']) ?>" class="thumbnail"<?php echo $item['ga_event'] ?>>
                        <?php if ($item['img']): ?>
                            <img src="<?php echo esc_attr($item['img']) ?>" alt="<?php echo esc_attr($item['title']); ?>" />
                        <?php endif; ?>
                    </a>					
                </div>
                <div class="col-md-7 col-sm-7 col-xs-12 cegg-desc-cell" style="vertical-align: top;">
                    
                    <a class="cegg-no-top-margin" rel="nofollow" target="_blank" href="<?php echo esc_url($item['url']) ?>"<?php echo $item['ga_event'] ?>>
                        <?php echo esc_html(TemplateHelper::truncate($item['title'], 80)); ?><?php if ($item['manufacturer'] && mb_strlen($item['title'], 'utf-8') < 80): ?>, <?php echo esc_html($item['manufacturer']); ?><?php endif; ?>                            
                    </a>
                    <div class="cegg-price cegg-price-color">
                        <?php if ($item['price']): ?>
                            <?php if ($item['old_price']): ?><small><strike class="text-muted"><?php echo TemplateHelper::formatPriceCurrency($item['old_price_raw'], $item['currency_code']); ?></strike>&nbsp;<?php endif; ?></small>
                            <strong><?php echo TemplateHelper::formatPriceCurrency($item['price_raw'], $item['currency_code']); ?></strong>
                        <?php endif; ?>
                    </div>                                
                </div>
            </div>
        <?php endforeach; ?>
    </div>

</div>