<?php

global $wpdb;

_ppt_template('framework/admin/header' ); 

 global $settings;
 
 
$plugins = array(

	1 => array(

	"name" => "Design Plugins",
	"desc" => "These plugins are recommended for additonal design options.",
	"data" => array(
		
		"elementor" => array(
			"t" => "Elementor", 
			"d" => "Elementor is a free drag-n-drop design editor for WordPress.", 
			"i" => "https://ps.w.org/elementor/assets/icon-128x128.gif",  
		),
		
		"datafeedr-api" => array(
			"t" => "Datafeedr API", 
			"d" => "This plugin lets you use Datafeedr on your WordPress website.", 
			"i" => "https://ps.w.org/datafeedr-api/assets/icon-256x256.png?rev=1335107"
		),
			
		"datafeedr-comparison-sets" => array(
			"t" => "Datafeedr Comparison Sets", 
			"d" => "Automatically create price comparison sets for your PremiumPress Website.", 
			"i" => "https://ps.w.org/datafeedr-comparison-sets/assets/icon-256x256.png?rev=1388272"
		),
		 /*
		"v10_icodes" => array(
			"t" => "iCodes Coupon Plugin", 
			"d" => "This plugin lets you import coupon codes from icodes.", 
			"i" => "https://ps.w.org/datafeedr-api/assets/icon-256x256.png?rev=1335107"
		),*/
	),
	
	
	
	),
	
	
	2 => array(

	"name" => "Text &amp; Language Plugins",
	"desc" => "This plugin will help you change text on your website.",
		"data" => array(
		
		
	 
		"loco-translate" => array(
			"t" => "Loco Translate", 
			"d" => "Translate WordPress themes directly in your browser", 
			"i" => "http://ps.w.org/loco-translate/assets/icon-256x256.png"
		),
 		 
	),
	),
	

	3 => array(

	"name" => "Security Plugins",
	"desc" => "These plugins help prevent spam and unauthorized website access.",
		"data" => array(
		
		
	 
		"wordfence" => array(
			"t" => "Wordfence Security", 
			"d" => "The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware", 
			"i" => "http://ps.w.org/wordfence/assets/icon-256x256.png?rev=1208450",  
			),
		),
	
	),
	
	

	4 => array(

		"name" => "Website Stories",
		"desc" => "These plugins are used for adding story options to your website.",
			"data" => array(
					
				"web-stories" => array(
					"t" => "Google Web Stories", 
					"d" => "Web Stories are a free, open-web, visual storytelling format for the web.", 
					"i" => "https://ps.w.org/web-stories/assets/icon-128x128.png", 
					"link" => "https://wordpress.org/plugins/web-stories/"
				),
	  
			
			),
		), 
	
	5 => array(

	"name" => "Payment Plugins",
	"desc" => "These plugins are used for accepting payments on your website.",
		"data" => array(
		
		
"plugindownload" => array("t" => "20+ Payment Gateway", "d" => "all payment gateways can be downloaded from our main website completely free.", "i" => "https://www.premiumpress.com/_demoimages/gateways/stripe.png", "link" => "https://stripe.com/"  ),
 
		
		
		
		),
	), 
	

);




if(THEME_KEY != "cp"){

unset($plugins[1]['data']['wlt_icodes']);

}

if(THEME_KEY != "cm"){

unset($plugins[1]['data']['datafeedr-api']);
unset($plugins[1]['data']['datafeedr-comparison-sets']);

}

?>

<div class="tab-content d-flex flex-column h-100">
  <?php foreach($plugins as $f){ ?>
  <?php if(isset($f['name'])){  


$settings = array("title" => $f['name'], "desc" => $f['desc']);
_ppt_template('framework/admin/_form-wrap-top' ); ?>
  <div class="card card-admin">
    <div class="card-body">
      <?php $i=1; foreach($f['data'] as $key => $p){ ?>
      <div class="row <?php if( $i != 1){ ?>border-top pt-3<?php } ?>">
        <div class="col-md-3"> <a class="media-left" href="#"> <img data-src="<?php echo $p['i']; ?>" style="width:100px;" class="lazy" alt="img" /> </a> </div>
        <div class="col-md-8">
          <h5><?php echo $p['t']; ?></h5>
          <div class="text-muted small"><?php echo $p['d']; ?></div>
          
          <?php if($key == "plugindownload"){ ?>
          
            <a href="https://www.premiumpress.com/plugins/?license=<?php echo get_option('ppt_license_key'); ?>" class="btn btn-system btn-md shadow-sm mt-3 mb-3" target="_blank"><?php echo __("Visit Page","premiumpress"); ?></a> 
          
          <?php }else{ ?>
          
          <a href="<?php echo home_url(); ?>/wp-admin/plugin-install.php?tab=plugin-information&plugin=<?php echo $key; ?>" class="btn btn-system btn-md shadow-sm mt-3 mb-3"><?php echo __("Install Now","premiumpress"); ?></a> 
          
          <?php } ?>
          
          </div>
      </div>
      <div class="clearfix"></div>
      <?php $i++; }?>
    </div>
  </div>
  <?php _ppt_template('framework/admin/_form-wrap-bottom' ); ?>
  <?php } ?>
  <?php }?>
</div>
<?php

_ppt_template('framework/admin/footer' ); 

?>