<?php
/* 
* Theme: PREMIUMPRESS CORE FRAMEWORK FILE
* Url: www.premiumpress.com
* Author: Mark Fail
*
* THIS FILE WILL BE UPDATED WITH EVERY UPDATE
* IF YOU WANT TO MODIFY THIS FILE, CREATE A CHILD THEME
*
* http://codex.wordpress.org/Child_Themes
*/
if (!defined('THEME_VERSION')) {	header('HTTP/1.0 403 Forbidden'); exit; }
 
require_once get_template_directory() ."/framework/data/_makes.php";

global $settings;

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

 $settings = array(
  
  "title" => __("Makes &amp; Models","premiumpress"), 
  "desc" => __("Use these tools to help you quickly import makes and models into your website.","premiumpress"),
  
  //"doclink" => "https://www.premiumpress.com/docs/users/",
  
  "video" => "",
  );
   _ppt_template('framework/admin/_form-wrap-top' ); 

 if(isset($_GET['addcarlogos'])){

	$termdata = get_terms('listing', 'orderby=count&order=desc&hide_empty=0&number=1000&parent=0');
	$newdata = array();
	 
	$i=1; $sf = 0;
	foreach ($termdata as $term) {

		// UPDATE ICON
		$newdata['storeimage_'.$term->term_id] = DEMO_IMGS."?cars=".$term->slug; 

		// UPDATE IMAGE
		if(defined('WLT_DEMOMODE') ){
		$newdata['category_image_'.$term->term_id] = DEMO_IMGS."?carbg=".$term->slug;  
		}

	}  
				
	// GET THE CURRENT VALUES
	$existing_values = get_option("core_admin_values");				 
	$new_result = array_merge((array)$existing_values, $newdata);
	update_option( "core_admin_values", $new_result, true);	
	

}
 
	 
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

$make = "";
$model = "";
if(isset($_GET['eid'])){ 
$make 	= get_post_meta($_GET['eid'],"make", true);
$model 	= get_post_meta($_GET['eid'],"model", true);
}

$list = array();
if(isset($GLOBALS['ppt_makes'])){
	$list = $GLOBALS['ppt_makes'];
}
$data = array();
foreach($list as $m){
	$data[str_replace(" ","",strtolower($m))] = __($m,"premiumpress");
}


$termdata = get_terms('listing', 'orderby=count&order=desc&hide_empty=0&number=1000&parent=0');
$total_cats = count($termdata);		

$categoryList = array();
$i=1; $sf = 0;
foreach ($termdata as $term) { 
 
	if($term->parent == "0"){
		
		$categoryList[$term->slug] = array("id" => $term->term_id, "name" =>  $term->name, "slug" => $term->slug, "data" => array(), "count" => $term->count );
	
	}elseif(isset($categoryList[$term->slug])){

    // CHECK FOR CITIES
    $cityArray = array();
    $citydata = get_terms('country', 'hide_empty=0&number=1000&parent='.$term->term_id);
    if(!empty($citydata)){
      foreach ($citydata as $cd) { 
        $cityArray[] = array("id" => $cd->term_id, "name" =>  $cd->name, "slug" => $cd->slug, "count" => $cd->count );
      }
    }

		array_push($categoryList[$term->slug]['data'], array("id" => $term->term_id, "name" =>  $term->name, "slug" => $term->slug, "data" => $cityArray , "count" => $term->count ) );
 
  }
}
 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

?>
<div class="card card-admin">
  <div class="card-body">

<?php if(isset($_GET['addcarlogos'])){ ?>

	<div class="alert alert-warning text-600 p-2"> Logos Updated</div>

<?php } ?>
  
  
<div class="text-center py-4" id="importmakes" style="display:none;">

    <i class="fa fa-sync fa-3x fa-spin"></i>
    <div class="text-600 my-4">Importing <span id="imcarn"></span> please wait..</div>

	<div class="opacity-5 small">This could take some time, please do not close this window..</div>


</div>
<?php
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

?>
<div id="makesimportlist">

<a href="edit-tags.php?taxonomy=listing&post_type=listing_type" class="btn-primary float-right" target="_blank" data-ppt-btn>Manage</a>

<div class="text-600 mb-2">Import Tool</div>


<div class="opacity-5">Click any brands below to begin import.</div>
<hr />
<div class="row">
<?php foreach($data as $k => $v){  ?>
        
 
<?php
$found = 0;

 
if(array_key_exists(strtolower($k), $categoryList)){
	$found = 1;
}
?>
<div class="col-md-3 mb-2">
<div data-ppt-btn class="btn-system btn-block cursor <?php if($found){ ?> opacity-5<?php }else{ ?>carid<?php } ?>" data-make="<?php echo $v; ?>" data-id="<?php echo $k; ?>" <?php if(!$found){ ?>onclick="ajax_import_makes('<?php echo $v; ?>','<?php echo $k; ?>');"<?php }else{ ?> onclick="alert('Already Imported');"<?php } ?>>
<?php if($found){ ?><i class="fa fa-check text-success mr-2"></i><?php } ?><?php echo $v; ?>
</div>
</div>

<?php } ?>
</div>

<hr>
<div class="mb-2"><a href="javascript:void(0);" onclick="ajax_import_allmakes()" class="btn-primary overflow-hidden" data-ppt-btn>Import All Makes (160)</a></div>
<hr>
<div class="mb-2"><a href="javascript:void(0);" onclick="ajax_import_allmodels()" class="btn-primary overflow-hidden" data-ppt-btn>Import All Makes + Models (1,000+)</a></div>
<hr>

<div><a href="javascript:void(0);" onclick="ajax_import_alllogos()" class="btn-primary overflow-hidden" data-ppt-btn>Import All Logos</a></div>
 
 
  
 </div> 



</div> 

</div>

  

<script>

function ajax_import_alllogos(){

	if(confirm("<?php echo trim(__("Are you sure?","premiumpress")); ?>")) {

		window.location.href='<?php echo get_home_url(); ?>/wp-admin/admin.php?page=stores&lefttab=makes&addcarlogos=1';

	}

}

function ajax_import_allmakes(){

	if(confirm("<?php echo trim(__("Are you sure?","premiumpress")); ?>")) {
	
	jQuery("#makesimportlist").hide(); 
	jQuery("#importmakes").show();          
				
					jQuery.ajax({
						type: "POST",
						dataType: 'json',	
						url: ajax_site_url,	 	
						data: {
							admin_action: "ajax_import_models", 
							 
						},
						success: function(response) {
						
							alert("Complete! "+response.count+" Items added.")
							 
								jQuery("#makesimportlist").show(); 
								jQuery("#importmakes").hide();   
							
							 
						},
						error: function(e) {
							 
						}
					});
			
	
	}// end are you sure

}


function ajax_import_allmodels(){

	if(confirm("<?php echo trim(__("Are you sure?","premiumpress")); ?>")) {

		jQuery("#makesimportlist").hide();
		jQuery("#importmakes").show(); 
		
		var timer=3000;
		jQuery( ".carid" ).each(function( index ) {
			
			var carid = jQuery( this ).data("id");
			var carmake = jQuery( this ).data("make");

			setTimeout(function(){	

				
				jQuery("#imcarn").html(carid); 
				
				jQuery.ajax({
						type: "POST",
						dataType: 'json',	
						url: ajax_site_url,	 	
						data: {
							admin_action: "ajax_import_makes",
							makeid: carid, 
							make: carmake,
						},
						success: function(response) { 
						  
							//jQuery("#makesimportlist").show();
							//jQuery("#importmakes").hide(); 
							
							 
						},
						error: function(e) {
							 
						}
				});

			},timer); 

			timer = timer + timer; 

		});
	
	}
}

 

function ajax_import_makes(make,id){ 
  
	
	if(confirm("<?php echo trim(__("Are you sure?","premiumpress")); ?>")) {
	
	jQuery("#makesimportlist").hide(); 
	jQuery("#importmakes").show();          
				
					jQuery.ajax({
						type: "POST",
						dataType: 'json',	
						url: ajax_site_url,	 	
						data: {
							admin_action: "ajax_import_makes",
							makeid: id, 
							make:make,
						},
						success: function(response) {
						
							alert("Complete! "+response.count+" Items added.")
							 
								jQuery("#makesimportlist").show(); 
								jQuery("#importmakes").hide();   
							
							 
						},
						error: function(e) {
							 
						}
					});
			
	
	}// end are you sure

}

</script>

<?php _ppt_template('framework/admin/_form-wrap-bottom' ); ?>