<?php
 
add_filter( 'ppt_blocks_args', 	array('block_category52',  'data') );
add_action( 'category52',  		array('block_category52', 'output' ) );
add_action( 'category52-css',  	array('block_category52', 'css' ) );
add_action( 'category52-js',  	array('block_category52', 'js' ) );

class block_category52 {

	function __construct(){}		

	public static function data($a){ 
  
		$a['category52'] = array(
			"name" 	=> "Carousel + Cat Images",
			"image"	=> "category52.jpg",
			"cat"	=> "category",
			"widget" => "ppt-category",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 52,			
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $category_settings, $settings;
	
	
 
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("category"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(

		    "tax" 		=> "listing",
		    "btn_show" => 1,

			"title" 		=> $CORE->LAYOUT("get_placeholder_text_new", array("short", "pop_cats" ) ),
			"subtitle" 		=> "Quidam officiis similique sea ei, vel tollit indoctum efficiendi.", 
		 );
		 

		$df = array_merge($df, $cc);
		
		
		// 1. ELEMENTOR
		if(!empty($category_settings)){
			foreach($df as $k => $v){				
				if(isset($category_settings[$k]) && $category_settings[$k] != "" ){
					$df[$k] = $category_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("category", "category52" ) );
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		}


///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	/// UsED TO SHOW HOW MANY IN CAROUSEL
    $limit = 6;
	if(isset($df['limit']) && $df['limit'] > 0){
	$limit = $df['limit'];
	} 


///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	
	
	
	$hide_empty = 1;
	if(isset($df['hide_empty']) && $df['hide_empty'] !=""){
	$hide_empty = $df['hide_empty'];
	} 
	
	$orderby = "menu_order";
	if(isset($df['orderby']) && $df['orderby'] != ""){
		$orderby = $df['orderby'];
	} 
	
	$order = "desc";
	if(isset($df['order']) && $df['order'] != ""){
		$order = $df['order'];
	} 
 
	$showOnlyCats = array();	
	if(!empty($df['cat'])){
		$showOnlyCats = $df['cat'];
		if(!is_array($showOnlyCats)){
		$showOnlyCats = array($showOnlyCats);
		}
	}
	
	
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

  
$termdata = get_terms($df['tax'], 'orderby='.$orderby.'&order='.$order.'&hide_empty='.$hide_empty.'&parent=0&number=20');
if(is_wp_error( $termdata )){ 
    echo $termdata->get_error_message(); 
    return;
}
$total_merchants = count($termdata);

$data = array(); $i=1;
foreach ($termdata as $term) {
 
        if(!empty($showOnlyCats) && !in_array($term->term_id,$showOnlyCats)){
        continue; 
        } 
         

        // SUB CATS ONLY
        if(isset($df['cat_subs']) && $df['cat_subs'] == "1"){
         
            $termdatasub = get_terms($df['tax'], 'orderby=count&order=desc&hide_empty='.$hide_empty.'&parent='.$term->term_id);
            if(is_wp_error( $termdatasub )){ 
                echo $termdatasub->get_error_message(); 
                return;
            }
              
            foreach ($termdatasub as $terms) {
            
                if($i > $limit){
                 continue;
                }
                
                if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
                $img =  $df['image'.$i];
                }else{
                $img = do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
                }
                    
                $data[] = array( 
                "name"	=> $CORE->GEO("translation_tax_with_termdata", $terms),  
                "link"	=> get_term_link($terms), 
                "count"	=> $terms->count,  
                "image" => $img,
                "icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="listing"]'),
                ); 
                
                $i++; 
            }
        
        // PARENT CAT
        }else{
        
        if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
        $img =  $df['image'.$i];
        }else{
            if($df['tax'] == "store"){
            $img = do_shortcode('[STOREIMAGE]');
            }else{
            $img = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
            }
        }
        
        $data[] = array( 
            "name"	=> $CORE->GEO("translation_tax_with_termdata", $term),  
            "link"	=> get_term_link($term), 
            "count"	=> $term->count,  
            "image" => $img,
            "icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]'),
        ); 
        
        $i++; 
        
        }

} 

	 
	
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
		
	ob_start();
	?>

<section class="section-top-40">
<div class="container">
<div class="row">

 

<?php if(strlen($df['title']) > 2){ ?>
<div class="col-12">
<div class="d-flex justify-content-between align-items-center">
	<div>	
		<h3 class="mb-1" data-ppt-title><?php echo $df['title']; ?></h3>
		<?php if(strlen($df['subtitle']) > 2){ ?><div class="mb-3" data-ppt-subtitle><?php echo $df['subtitle']; ?></div><?php } ?>
	</div>

	<?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 1){ ?>
	<div class="justify-content-center">
	<a href="<?php echo home_url(); ?>/?s=" data-ppt-btn data-ppt-btn-link class="btn-system btn-rounded-25 btn-md"><?php echo $df['btn_txt']; ?></a>
	</div>
	<?php } ?>
</div>
</div>
<?php } ?>
  

 
<div class="col-12 overflow-hidden">

<div class="position-relative">
<div class="listing1-carousel-1 owl-carousel owl-theme" data-0="1" data-1200="<?php echo $limit; ?>" data-1000="<?php echo $limit; ?>" data-margin="10" data-autoplay="1">
<?php $i=1; foreach($data as $cat){    ?>
 
      
    <div class="card-category52">
         <div class="bg-image <?php if($df['tax'] == "store"){ echo "p-5"; } ?>" data-bg="<?php  if($df['tax'] == "store"){ echo $cat['icon'];   }else{ echo $cat['image']; } ?>" <?php if($df['tax'] == "store"){ ?>style="background-repeat: no-repeat;"<?php } ?>>&nbsp;</div>
        <div class="bg-gradient" style="z-index:1;">&nbsp;</div>
          <h5><a href="<?php echo $cat['link']; ?>"><?php echo $cat['name']; ?></a></h5>
        </div>


    

<?php $i++; } ?>    
</div>
    <div class="position-absolute w-100" style="top: 30%;">
        <ul class="d-flex justify-content-between">
            <li><a href="javascript:void(0);" class="btn prev btn-system opacity-5" data-ppt-btn><span class="fa fa-arrow-left"></span></a></li>
            <li><a href="javascript:void(0);" class="btn next btn-system opacity-5 c52-bt" data-ppt-btn><span class="fa fa-arrow-right"></span></a></li>
        </ul>
    </div>
</div>

</div> 
 
<?php

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

?> 

  
</div>
</div>
</section>
<?php
		$output = ob_get_contents();
		ob_end_clean();
		
echo ppt_theme_block_output($output, $df, array("category", "category52"));

	
	}
		public static function css(){
		ob_start();
		?>
<style>

.card-category52{position:relative;text-align:center;margin-bottom:30px;cursor:pointer;z-index:1;width:100%;height:230px; border-radius: 8px;     overflow: hidden; }
.card-category52:hover h5{bottom:42px;}
.card-category52:hover p{visibility:visible;bottom:15px;opacity:1;}
.card-category52 h5{position:absolute;bottom:30px;left:50%;z-index:1;width:100%;font-weight:500;text-align:center;text-transform:capitalize;-webkit-transform:translateX(-50%);transform:translateX(-50%);transition:all linear .3s;-webkit-transition:all linear .3s;-moz-transition:all linear .3s;-ms-transition:all linear .3s;-o-transition:all linear .3s;}
.card-category52 h5 a{color:#fff;}
 
 
 
.mobile-icon-text { font-size:14px !important; }

</style>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
	 
		ob_start();
		?>
<script>
jQuery(document).ready(function(){ 

    setTimeout(function(){ 	
                
        jQuery(".c52-bt").trigger("click");

        },3000);
   
});
</script>

<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>
