<?php
 
add_filter( 'ppt_blocks_args', 	array('block_listings_stories',  'data') );
add_action( 'listings_stories',  		array('block_listings_stories', 'output' ) );
add_action( 'listings_stories-css',  	array('block_listings_stories', 'css' ) );
add_action( 'listings_stories-js',  	array('block_listings_stories', 'js' ) );

class block_listings_stories {

	function __construct(){}		

	public static function data($a){ 
  
		$a['listings_stories'] = array(
			"name" 	=> "web stories",
			"image"	=> "listings_stories.jpg",
			"cat"	=> "listings",
			"widget" => "ppt-listings",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 50,			
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $listing_settings, $settings, $wpdb; 
	
 
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("listings"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(

			"title" => "Latest Stories"
		 );
		 

		$df = array_merge($df, $cc);
		
		
		// 1. ELEMENTOR
		if(!empty($listing_settings)){
			foreach($df as $k => $v){				
				if(isset($listing_settings[$k]) && $listing_settings[$k] != "" ){
					$df[$k] = $listing_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("listings", "listings_stories" ) );
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		} 

        // CIRCLE OR CAROUSEL
        $view_type = "circles";
        if($df['card'] != "list"){
            $view_type = "carousel";
        }

        // LIMIT
        $limit = 11;
        if(isset($df['show']) && is_numeric($df['show'])){
            $limit = $df['show'];
        }

        // ORDER BY
        $orderby = "ID";
        if(isset($df['orderby']) && $df['orderby'] != ""){
            $orderby = $df['orderby'];
        }

         // ORDER
         $order = "desc";
         if(isset($df['order']) && $df['order'] != ""){
             $order = $df['order'];
         }
        
	
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
		
	ob_start();


	?>

 

<section class="section-top-40">
<div class="container"> 

<div class="row">



<?php if(strlen($df['title']) > 1){ ?>
  <div class="col-md-12">
    <div <?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 2){ ?> class="d-flex justify-content-between align-items-center"<?php } ?>>

    <div>

      <h2 data-ppt-title><?php echo $df['title']; ?></h2>

     <?php if(strlen($df['subtitle']) > 2){ ?> 
      <p data-ppt-subtitle><?php echo $df['subtitle']; ?></p>
      <?php } ?>

    </div>
      
    <?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 2){ ?>
        <div class="justify-content-center">
        <a href="<?php echo home_url(); ?>/?s=" data-ppt-btn data-ppt-btn-link class="btn-system btn-rounded-25 btn-md"><?php echo $df['btn_txt']; ?></a>
        </div>
    <?php } ?>
      
    </div>
  </div>
  <?php } ?>

  <div class="col-12">

  <?php
  
 
 

  if(isset($_GET['action']) || isset($_POST['actions']) ){

	if($view_type == "circles"){

		echo '<img src="https://premiumpress1063.b-cdn.net/_demoimagesv10/blocks/video/stories_d2.jpg" class="img-fluid">';

	}else{

		echo '<img src="https://premiumpress1063.b-cdn.net/_demoimagesv10/blocks/video/stories_d1.jpg" class="img-fluid">';


	} 

  }else{ 
	
	
	echo do_shortcode("[web_stories view='".$view_type."'  title='false' 
	excerpt='false' 
	author='false' 
	date='false' 
	archive_link='false' 
	archive_link_label='' 
	circle_size='100'
	sharp_corners='false' 
	image_alignment='left' 
	number_of_columns='1'
	number_of_stories='".$limit."' 
	order='".$order."' 
	orderby='".$orderby."'  /]"); 
	
  }?>



 

 </div>

  </div>

</div>
</section> 

<?php
		$output = ob_get_contents();
		ob_end_clean();
		
echo ppt_theme_block_output($output, $df, array("category", "listings_stories"));

	
	}
		public static function css(){
		ob_start();
		?>
		 <style>
.web-stories-list__inner-wrapper {
    margin: 0 auto;
    display:block;
    position: relative;
}

.web-stories-list__story { width:185px;     display: inline-block; }
.web-stories-list.is-carousel .web-stories-list__inner-wrapper { max-width:100% !important;  }	
			
.web-stories-list__story-poster {
 
    border-radius: 10px;
    overflow: hidden;
 

}		

.web-stories-list.is-view-type-circles .glider-track { margin:0!important; }
			
			
			</style>
 
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
		 
		ob_start();
		?> 



<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>
