<?php
/* 
* Theme: PREMIUMPRESS CORE FRAMEWORK FILE
* Url: www.premiumpress.com
* Author: Mark Fail
*
* THIS FILE WILL BE UPDATED WITH EVERY UPDATE
* IF YOU WANT TO MODIFY THIS FILE, CREATE A CHILD THEME
*
* http://codex.wordpress.org/Child_Themes
*/
if (!defined('THEME_VERSION')) {	header('HTTP/1.0 403 Forbidden'); exit; }
 
global $CORE;  

$GLOBALS['set-searchmap'] = 1;
 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
 
?>

<div class="ppt-js-trigger-search-finished"></div>
<div class="col-12 mb-4" id="map-wrapper" style="display:none;">
    <div class="card shadow position-relative map-container " id="ppt_search_map2024"> 
  
    <div class="card-body p-0"  style="height:200px;width:100%;">
   	    <div id="newmap"></div> 
    </div>
        <ul class="mapnavigation bg-primary list-unstyled m-0" style="bottom:20px;z-index:999;display:none;">
            <li><a href="#" class="prevmap-nav1"><?php echo __("Prev","premiumpress"); ?></a></li>
            <li><a href="#" class="nextmap-nav1"><?php echo __("Next","premiumpress"); ?></a></li>
        </ul>
    </div>


    <textarea id="mapdatabox" class="dynamic_map" style="display:none; height:100px;">none</textarea>
    <input value="<?php if(is_numeric(_ppt(array('maps','zoom')))){ echo _ppt(array('maps','zoom')); }else{ echo 15; } ?>" class="map-zoom" type="hidden" />
  
  
  
</div> 

<div id="filterMap"  data-longitude="" data-latitude=""></div>
<?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>
<link href="https://api.mapbox.com/mapbox-gl-js/v3.4.0/mapbox-gl.css" rel="stylesheet">
<script src="https://api.mapbox.com/mapbox-gl-js/v3.4.0/mapbox-gl.js"></script>
<?php }elseif(_ppt(array("maps","provider")) == "google"){
     
    ?>
 
<div class="ppt-google-maps-loaded"></div><!-- trigger for when maps are loaded -->
<div id="map-main"></div><!-- trigger for when maps are loaded -->

<?php } ?>
<style>
    #newmap { position: absolute; top: 0; bottom: 0; width: 100%; }
    .mapviewicon {display:none; }
</style>
 

<script>

 
var map;
var dzoom = 11;
var allMarkers = [];
var current_marker_num;
var PageFirstSet = 0;
var LastMarkerData = [];

jQuery(document).ready(function(){  

<?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>

        LoadInMap();       

 <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>

    jQuery(".ppt-google-maps-loaded").on('click', function(){   
        
            LoadInMap();  
             
    });     

<?php } ?>

});

jQuery(".ppt-js-trigger-search-finished").on('click', function(){  
 

    <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>

        LoadInData();    
        
        if(PageFirstSet == 0){
            ZoomAllMmarkers();
            PageFirstSet = 1;
        }else{
            ZoomLastMarker(); 
        }

    <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>

        if( window.google && google.maps ) { LoadInData(); }else{

            setTimeout(function(){ 	
                
                LoadInData();

                if(PageFirstSet == 0){
                    ZoomAllMmarkers();                    
                    PageFirstSet = 1;
                }else{
                    ZoomLastMarker(); 
                }

                jQuery("#map-wrapper").show();

        }, 4000);
        }

    <?php } ?> 
    


  
     
});

function ZoomAllMmarkers(){
    
    if(allMarkers.length > 0){

    <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?> 
        bb = [];
        for( i = 0; i < allMarkers.length; i++ ) {
            console.log(allMarkers[i]._lngLat);
            
            bb.push([allMarkers[i]._lngLat.lng, allMarkers[i]._lngLat.lat]);	

        }  
        map.fitBounds(bb);
        map.setZoom(4); 

        setTimeout(function(){ 	
            jQuery("#map-wrapper").show();
            map.resize();
        }, 1000);

    <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>

        var bounds = new google.maps.LatLngBounds();

        bb = [];
        for( i = 0; i < allMarkers.length; i++ ) {             
            bounds.extend(allMarkers[i].position);
        }

        map.fitBounds(bounds);

    <?php } ?>

    if(allMarkers.length > 1){
        jQuery(".mapnavigation").show();
    }

    }

}
function ZoomLastMarker(){

    if(allMarkers.length > 1){
     jQuery(".mapnavigation").show();
    }

    if(!isNaN(LastMarkerData["lng"])) {
    <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>       
        

            if(allMarkers.length > 0){ 
                map.easeTo({ center: [LastMarkerData["lng"],LastMarkerData["lat"]], zoom: dzoom });               
            }  

            setTimeout(function(){ 	
                jQuery("#map-wrapper").show();
                map.resize();
            }, 1000)

    <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>

            if(allMarkers.length > 0){
                var latlng = new google.maps.LatLng(LastMarkerData["lat"],LastMarkerData["lng"]);			
                map.setZoom(10);		 
                map.panTo(latlng);
            }
            
            jQuery("#map-wrapper").show();
                
    <?php } ?> 
    }

}

function LoadInMap(){  

    <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>
    mapboxgl.accessToken = '<?php echo _ppt(array('maps','apikey')); ?>';
    map = new mapboxgl.Map({
        container: 'newmap',  
        center: [-74.5, 40], 
        zoom: dzoom,  
    });
    <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>
    
    var myLatlng = new google.maps.LatLng(0,0);
	var myOptions = { zoom: 1,  center: myLatlng,  disableDefaultUI: true, mapTypeId: google.maps.MapTypeId.ROADMAP, mapId: "ppt_search_map2024" }
	map = new google.maps.Map(document.getElementById("newmap"), myOptions, );

    <?php } ?>

}
function LoadInData(){  


    // CLEAR ALL CURRENT MARKERS
    if(allMarkers.length > 0){
        for( i = 0; i < allMarkers.length; i++ ) {   
            <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>
            allMarkers[i].remove();
            <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>
            allMarkers[i].setMap(null);
            <?php } ?>
        }
    }


    // LOAD IN NEW ONES
    var fc = 0;
   jQuery("[data-newlatitude]").each(function(){             

            long        = jQuery(this).attr('data-newlongitude');
            lat         = jQuery(this).attr('data-newlatitude');

            url         = jQuery(this).attr('data-url');
            img         = jQuery(this).find(".bg-image").attr('data-bg');
            title       = jQuery(this).attr('data-title');
            address     = jQuery(this).attr('data-address');
            
            if ( lat != 'undefined' && long != 'undefined' && !isNaN(lat) && !isNaN(long)   ) {

                if(fc == 0){
                    LastMarkerData = [{"lng":parseFloat(long), "lat":parseFloat(lat), "name": title}];
                }

                <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>
                
                var marker = new mapboxgl.Marker({draggable: false}).setLngLat([long, lat]).setPopup(new mapboxgl.Popup({closeOnClick: true, offset: [20, 0]}).setHTML(locationNewData(url, img, title, address))).addTo(map);
                allMarkers.push(marker);
                setAllMarkesrColor(allMarkers, "blue");
				setMarkerColor(marker, "red");

                <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?>                     

                    const AdvancedMarkerElement = new google.maps.marker.AdvancedMarkerElement({
                        map,
                        position: new google.maps.LatLng(lat,long),
                        title: title,
                        content: buildContent('<h6><a href=' + url + '>' + title + '</a></h6><span class="text-muted">' + address + '</span>'),
                    });

                    allMarkers.push(AdvancedMarkerElement); 

                    AdvancedMarkerElement.addListener("click", () => { 
                        toggleHighlight(AdvancedMarkerElement);
                    });                                     
                
                <?php } ?>                 
                 
                 fc++;
            }
 
    }); // end loop
      
    // SET MARKERS ID
	current_marker_num = 0; 

}
 
 

jQuery('.nextmap-nav1').on("click", function (e) { 

e.preventDefault(); 
 
 current_marker_num = current_marker_num + 1; 
 
 if(typeof allMarkers[current_marker_num] != 'undefined'){
     
    Marker_Click(allMarkers[current_marker_num]);
 
}else{

    current_marker_num = 0;
}

});

jQuery('.prevmap-nav1').on("click", function (e) {           
 
e.preventDefault(); 

 current_marker_num = current_marker_num - 1; 
 
 if(typeof allMarkers[current_marker_num] != 'undefined'){

    Marker_Click(allMarkers[current_marker_num]);
 
}else{

    current_marker_num = allMarkers.length;
}
 
});	

 
 

function locationNewData(url, img, title, subtitle) {
            return ('<div class="map-popup-wrap"><div class="map-popup"><a href="' + url + '"><div class="listing-content fl-wrap"><div class="listing-title fl-wrap"><h4><a href=' + url + '>' + title + '</a></h4><span class="text-muted">' + subtitle + '</span></div></div></div></div>');

}   
function setMarkerColor(marker, color) {
		var $elem = jQuery(marker.getElement());
		$elem.find('svg g[fill="' + marker._color + '"]').attr('fill', color);
		marker._color = color;
	}
	
function setAllMarkesrColor(allMarkers, color) { 
		
		for( i = 0; i < allMarkers.length; i++ ) {
			
			var $elem = jQuery(allMarkers[i].getElement());
			$elem.find('svg g[fill="' + allMarkers[i]._color + '"]').attr('fill', color);
			allMarkers[i]._color = color; 
		
		} 
		
		
}
function Marker_Click(marker){	
		  
		
		if(typeof marker != 'undefined'){

        <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>
  
            map.easeTo({
				center: [marker._lngLat['lng'], marker._lngLat['lat']],
				zoom: 12
			});	

            map.resize();	

        <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?> 
   
            latlng = new google.maps.LatLng(marker.position);				 
			map.panTo(latlng);			
			map.setZoom(15);

        <?php } ?>			 
					 
		} 
			
}

/*
trigered when the distance filer box is used
*/
jQuery("#location-mylog").on('change', function(){   

    if(jQuery("#location-mylog").val() != ""){
        filterNewMap(jQuery("#location-mylog").val(), jQuery("#location-mylat").val()  );
    }

});
function filterNewMap(latx, lngx) {
 
	  
         if(typeof latx !== "undefined"){	

           

            latx = parseFloat(latx);
            lngx = parseFloat(lngx);
         
            radius = 100;
            nzoom = 11;
            if(jQuery('.distance-slider').length > 0){
                radius = jQuery('.distance-slider').val();                
            }

            <?php if(_ppt(array("maps","provider")) == "mapbox"){ ?>

                nzoom = 10;
                if(radius > 0 && radius < 30 ){
                    nzoom = 15; 
                }else if(radius > 31 && radius < 99 ){
                    nzoom = 12;  
                }else if(radius > 100 && radius < 199 ){
                    nzoom = 7;
                }else if(radius > 200 ){
                    nzoom = 5;
                }          

                map.easeTo({
				center: [latx, lngx],
				zoom: nzoom,
		        });  

            <?php }elseif(_ppt(array("maps","provider")) == "google"){ ?> 
 
                var latlng = new google.maps.LatLng(lngx,latx);			
                 map.setZoom(15);		 
                 map.panTo(latlng);

            <?php } ?>


         } 

 
         LoadInData();

}

</script>

<?php if(_ppt(array("maps","provider")) == "google"){ ?> 
<script>
function buildContent(html) {

const display = document.createElement("div");
display.innerHTML = '<div class="icon">&nbsp;</div><div class="details">'+html+'</div>';
display.classList.add("property");
return display;

}

function toggleHighlight(markerView) {
if (markerView.content.classList.contains("highlight")) {
    markerView.content.classList.remove("highlight");
    markerView.zIndex = null;
} else {
    markerView.content.classList.add("highlight");
    markerView.zIndex = 1;
}
}
</script>
<style>
.property {
  align-items: center;
  background-color: red;
  border-radius: 50%;
  color: #263238;
  display: flex;
  font-size: 14px;
  gap: 15px;
  height: 30px;
  justify-content: center;
  padding: 4px;
  position: relative;
  position: relative;
  transition: all 0.3s ease-out;
  width: 30px;
}

.property::after {
  border-left: 9px solid transparent;
  border-right: 9px solid transparent;
  border-top: 9px solid red;
  content: "";
  height: 0;
  left: 50%;
  position: absolute;
  top: 95%;
  transform: translate(-50%, 0);
  transition: all 0.3s ease-out;
  width: 0;
  z-index: 1;
}
.property .details {
  display: none;
  flex-direction: column;
  flex: 1;
}
.property .icon {
  align-items: center;
  display: flex;
  justify-content: center;
  color: #FFFFFF;
}

.property.highlight {
  background-color: #FFFFFF;
  border-radius: 8px;
  box-shadow: 10px 10px 5px rgba(0, 0, 0, 0.2);
  height: 80px;
  padding: 8px 15px;
  width: auto;
}
.property.highlight .details {
  display: flex;
}
</style>
<?php } ?>