<?php
/* 
* Theme: PREMIUMPRESS CORE FRAMEWORK FILE
* Url: www.premiumpress.com
* Author: Mark Fail
*
* THIS FILE WILL BE UPDATED WITH EVERY UPDATE
* IF YOU WANT TO MODIFY THIS FILE, CREATE A CHILD THEME
*
* http://codex.wordpress.org/Child_Themes
*/
if (!defined('THEME_VERSION')) {	header('HTTP/1.0 403 Forbidden'); exit; }

global $CORE, $CORE_UI, $LAYOUT, $wpdb, $wp_query, $userdata;
 
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
 

$term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

$ThisTermID = $term->term_id; 

$title = $CORE->GEO("translation_tax", array($term->term_id, $term->name));

$description = "";
if( strlen($term->description) > 0){
	$description  = $term->description;
}elseif( strlen(_ppt('category_description_'.$term->term_id)) >  5){  
	$description = _ppt('category_description_'.$term->term_id);
} 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////


register_taxonomy( $taxonomy, THEME_TAXONOMY.'_type', array( 'hierarchical' => true, 'labels' => array('name' => $taxonomy) , 
'query_var' => true, 'rewrite' => true, 'rewrite' => array('slug' => $taxonomy) ) ); 

$parent = $term->parent;
if($parent == "0"){
$parent = $term->term_id;
}


///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

// GET TERMS

if($term->parent != 0){
  $tlevel = 1;
  $cats = get_terms( $taxonomy, array( 'hide_empty' => 0, 'parent' => $ThisTermID )); 
 
  if(empty($cats)){
    $cats = get_terms( $taxonomy, array( 'hide_empty' => 0, 'parent' => $parent )); 
    $tlevel = 1;
  }else{
    $tlevel = 2;
  }

}else{
  $tlevel = 0;
  $cats = get_terms( $taxonomy, array( 'hide_empty' => 0, 'parent' => $parent )); 

} 
 
?> 

<div class="bg-white border-bottom">

  <div class="py-3 border-bottom">
    <?php _ppt_template( 'search/search-breadcrumbs' ); ?>
  </div>

  
  <div class="container py-3">

    <div class="row">

		<div class="col-3">  
	
		    <div class="d-md-flex align-self-center">
       
         <h1 class="fs-md mb-2 mt-1 text-600"><?php echo $title; ?></h1> 
         
         <span class="mt-2 ml-3 flag <?php echo $CORE->GEO("get_flagicon_from_name", array( $term->name, $GLOBALS['core_country_list_new']));  ?>"></span>
     
        </div>  


        
   <?php if(count($cats) > 12){ ?>
<div>
    <a data-ppt-btn class="btn btn-secondary btn-sm shadow-0" href="#" onclick="SetMaxHeightlisting<?php echo $taxonomy; ?>();"><span class="showmoreless<?php echo $taxonomy; ?>"><?php echo __("Show All","premiumpress") ?> <i class="fa fa-long-arrow-alt-right ml-3"></i> </span></a>
</div>


<?php } ?>
     
		</div> 
   

    <div class="col-9 px-0">  

 
    <?php if(strlen($description) > 2 ) { ?>
			<div class="opacity-5"><?php echo strip_tags($description); ?></div>
      <?php } ?>
      <?php
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

if(!empty($cats)){
?>
<div class="max_height_desc<?php echo $taxonomy; ?>">
<div class="container">
<div class="row">
<?php

  foreach($cats as $cat){   ?>

    <div class="tax-div tax-val-<?php echo $cat->term_id; ?> col-6 col-md-4 col-xl-3 text-600 border-bottom-0">
    
    <label class="custom-control custom-radio f-<?php echo $taxonomy."-".$cat->term_id; ?> ccl">
      
        <input 
        type="radio"
        value="<?php echo $cat->term_id; ?>" 
        name="catid[]" 
        class="custom-control-input customfilter" 
        data-type="checkbox" 
        onclick="_filter_update()" 
        data-key="taxonomy" 
        data-value="<?php echo $taxonomy; ?>-<?php echo $cat->term_id; ?>"
            <?php if(isset($GLOBALS['flag-taxonomy-id']) && $GLOBALS['flag-taxonomy-id'] == $cat->term_id){ echo "checked=checked"; } ?>>
    
        <div class="custom-control-label" data-countkey="<?php echo $taxonomy; ?>-<?php echo $cat->term_id; ?>">
          
         
        <div class="d-flex justify-content-between">
          
              <div class="filtertxt  small"> <?php echo $CORE->GEO("translation_tax_value", array($cat->term_id, $cat->name));  ?> </div>
     
            
             <div class="<?php if($term->parent != 0){ ?>addcount<?php } ?> ml-3" data-countkey="<?php echo $taxonomy; ?>-<?php echo $cat->term_id; ?>"><?php if($cat->count > 0){ ?><span class="badge badge-lightxx text-dark border"><?php echo $cat->count; ?></span> <?php } ?></div>
             
    
              <?php if($tlevel != 2 ){  
               
                  $hasmore = get_terms( $taxonomy, array( 'hide_empty' => 1, 'parent' => $cat->term_id )); 
    
                  if(!empty($hasmore)){
                ?>
              <div>
                <a href="<?php echo get_term_link( $cat->term_id, $taxonomy); ?>" class="btn btn-sm btn-system"> <?php echo __("More","premiumpress"); ?> </a>
              </div>
              <?php } } ?> 
              
              
          </div>      
           
        
          
        </div>
    
    </label>
    
    </div>
    <?php  } 
   ?>
   </div></div></div>


   <style>
.ccl { font-size:18px; }
.ccl .custom-control-label::before { top: 6px; }
.ccl .custom-control-label::after { top:6px;}
.max_height_desc<?php echo $taxonomy; ?>:not(.showmore<?php echo $taxonomy; ?>) { height:100px; overflow:hidden; }
@media (max-width: 575.98px) { 
.ccl { font-size:14px; }
.ccl .custom-control-label::before { top: 3px; }
.ccl .custom-control-label::after { top:3px;}
.max_height_desc<?php echo $taxonomy; ?>:not(.showmore<?php echo $taxonomy; ?>) { height:105px; overflow:hidden;   }
.max_height_desc<?php echo $taxonomy; ?> { font-size:12px; margin-top:20px; }
}
</style>
<script>

function SetMaxHeightlisting<?php echo $taxonomy; ?>(){
	
	if(jQuery('.showmore<?php echo $taxonomy; ?>').length > 0){	
		jQuery('.max_height_desc<?php echo $taxonomy; ?>').removeClass('showmore<?php echo $taxonomy; ?>');	
		 jQuery('.showmoreless<?php echo $taxonomy; ?>').html("<?php echo __("Show All","premiumpress") ?>  <i class='fa fa-long-arrow-alt-right ml-3'></i>");	
	}else{	
		jQuery('.max_height_desc<?php echo $taxonomy; ?>').addClass('showmore<?php echo $taxonomy; ?>');
		jQuery('.showmoreless<?php echo $taxonomy; ?>').html("<?php echo __("Hide","premiumpress") ?>");
	}

}
</script> 
   <?php 

}
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
 
?>
     </div>  </div>

</div>
</div> 


</div> 