<?php

namespace BookneticApp\Providers\Core;

use BookneticApp\Providers\Helpers\Helper;

class LicenseService
{
    public static function checkLicense()
    {
        $alert    = Helper::getOption('plugin_alert', '', false);
        $disabled = Helper::getOption('plugin_disabled', '0', false);

        if ($disabled === '1') {
            return false;
        } elseif ($disabled === '2') {
            if (! empty($alert)) {
                echo $alert;
            }

            exit();
        }

        if (! empty($alert)) {
            add_action('admin_notices', function () use ($alert) {
                echo '<div class="notice notice-error"><p>'.$alert.'</p></div>';
            });
        }

        return true;
    }
}
