/**
 * yith-infs.js
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH Infinite Scrolling
 * @version 1.0.0
 */

if ( 'scrollRestoration' in history ) {
    // Back off, browser, I got this...
    history.scrollRestoration = yith_infs_script.scroll_restoration;
}

( function( $ ) {
    "use strict";

    if( typeof yith_infs_premium !== 'undefined' && yith_infs_premium.options ) {

        $.fn.init_infinitescroll = function() {
            $.each( yith_infs_premium.options, function (key, value) {

                if( ! ( $( value.nextSelector ).length && $( value.navSelector ).length && $( value.itemSelector ).length && $( value.contentSelector ).length ) ) {
                    return;
                }

                $.yit_infinitescroll(value);
            });
        };

        $.fn.init_infinitescroll();

        $(document).on( 'yith-wcan-ajax-loading', function(){
            // reset
            $( window ).unbind( 'yith_infs_start' );
            $( '.yith-infs-button-wrapper' ).remove();
        });

        $(document).on( 'yith-wcan-ajax-filtered woof_ajax_done facetwp-loaded', function(){
            // reset
            $( window ).unbind( 'yith_infs_start' );
            // initialize
            $.fn.init_infinitescroll();
        });

    }
})( jQuery );